-------------------------------------------------------------------------
--     Scripted Plugin for the Arnold cyl_camera
-------------------------------------------------------------------------
plugin Camera arnold_cyl_camera
extends:FreeCamera
name:"Cylindrical"
classID:#(515154,262400)
category:"Arnold"
replaceUI:true
(
	parameters main rollout:params
	(
		arnold_node type:#string default:"cyl_camera"
		arnold_node_horizontal_fov type:#float default:60.0 ui:horizontalFov
		arnold_node_vertical_fov type:#float default:90.0 ui:verticalFov
		arnold_node_projective type:#boolean default:true ui:projective
	)
  
	-- Hack to touch a parameter that the camera translator "cares" about to 
	-- trigger a retranslation. Ugly, but.... works for now :D
	fn forceUpdate = 
	(
		if delegate.fov == 160 then delegate.fov = 160.001 else delegate.fov = 160		
	)
  
	rollout params "Parameters"
	(
		-- This is a workaround for the camera being too smart, and ignoring any
		-- updates that are not in its set of "parameters I care about"
		spinner horizontalFov "Horizontal FOV" range:[0.001,360.0,60.0]
		spinner verticalFov "Vertical FOV" range:[0.001,180.0,90.0]
		checkbox projective "Projective"

		on horizontalFov changed val do forceUpdate()
		on verticalFov changed val do forceUpdate()
		on projective changed val do forceUpdate()
	)
	
	tool create
	(
		on mousePoint click do
			case click of
			(
				1: nodeTM.translation = gridPoint
				2: (
					setCommandPanelTaskMode #modify					
					#stop
				)
			)
		on mouseMove click do
			if click == 2 then nodeTM.translation = gridPoint
	)

	on create do forceUpdate()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAbEtNkdC/UfI5FK9jfVIMGt4MJ1w+63sml
-- zhTJt0D3X9/CVZZdjhLXuIvFhERPwDgL4MzReq2T5F+wLrPHf4NhWI9forlv1cF1
-- 87egKJAt0Vmzls27ihk5Oe87W+540RNTn0e94u3lzMc+hp1h3Xtv2xr0y0LMP3CB
-- 0u1Q88BiAQmidDz2Pt56HD6PliYu8zAo2QSkohe6CJwYc6jrsU7ownT6z/lIzkH8
-- ZSM2jITN50Jnx1oS0pGR1qHfv+6vqZJnTba2K1NwEeR365oYEBf7wztqGKiHFsQJ
-- krzJQer6KPh8Lxm2CZd01da6zfZBwYda03vNkhijPg+35oUmcmnn
-- -----END-SIGNATURE-----